<div class="min-h-[calc(100vh-152px)]">
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Produtos</h2>
    <?php
    $category_id = filter_input(INPUT_GET, 'categoriaid', FILTER_VALIDATE_INT);
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);

    $nomeCategoria = new Read;
    $nomeCategoria->ExeRead(DB_CATEGORIAS, " WHERE id_categoria = {$category_id}");
    $nomeC = $nomeCategoria->getResult()[0]['nome'];

    if (isset($post) && $post['SendPostForm']):
        unset($post['SendPostForm']);

        require('_models/Produtos.class.php');
        $cadastra = new Produtos;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()):
            header('Location: painel.php?exe=produtos/create_product&create=true&categoriaid=' . $category_id . '&produtoid=' . $cadastra->getResult());
        else:
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)):
        WSErro("O produto foi cadastrado com sucesso!", WS_ACCEPT);
    endif;
    ?>
    <br />
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Cadastrar produto</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id_categoria" value="<?= $category_id; ?>" />
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Produto</label>
                        <input type="text" class="form-input" name="nome" placeholder="Informe o nome do produto" value="<?php if (isset($post['nome']))
                            echo $post['nome']; ?>" autofocus>
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Valor</label>
                        <input type="text" class="form-input" name="preco" placeholder="Informe o valor" value="<?php if (isset($post['preco']))
                            echo $post['preco']; ?>">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Local
                            de preparo</label>
                        <select name="destino" class="form-select">
                            <option value="">Selecione</option>
                            <option value="1">Cozinha</option>
                            <option value="2">Churrasqueira</option>
                            <option value="0">Não se aplica</option>
                        </select>
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estoque
                            atual</label>
                        <input type="text" class="form-input" name="estoque_atual" placeholder="Informe o estoque atual"
                            value="<?php if (isset($post['estoque_atual']))
                                echo $post['estoque_atual']; ?>">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Estoque
                            mínimo</label>
                        <input type="text" class="form-input" name="estoque_minimo"
                            placeholder="Informe o estoque mínimo para receber um alerta" value="<?php if (isset($post['estoque_minimo']))
                                echo $post['estoque_minimo']; ?>">
                    </div>

                </div>
                <div>
                    <br />
                    <input type="submit"
                        class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700"
                        value="Cadastrar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>

    <br />
    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty):
        WSErro("Ops: Você tentou editar um produto que não existe no sistema!", WS_INFOR);
    endif;

    $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
    if ($action):
        require('_models/Produtos.class.php');

        $postAction = filter_input(INPUT_GET, 'produtoid', FILTER_VALIDATE_INT);
        $postUpdate = new Produtos;

        switch ($action):
            case 'delete':
                $postUpdate->ExeDelete($postAction);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Produtos cadastrados na categoria -
        <?= $nomeC; ?></h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Categoria</th>
                            <th>Valor</th>
                            <th>Estoque</th>
                            <th class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $produtos = new Read;
                        $produtos->ExeRead(DB_PRODUTOS, " WHERE id_categoria = {$category_id} ORDER BY id_categoria ASC");
                        foreach ($produtos->getResult() as $produto):
                            extract($produto);

                            $vendas = new Read;
                            $vendas->FullRead("SELECT SUM(qtd) AS qt FROM " . DB_CARRINHO . " WHERE cod = {$cod}");
                            $qt = $vendas->getResult()[0]["qt"];

                            $entradas = new Read;
                            $entradas->FullRead("SELECT SUM(entry_qt) AS qt FROM " . DB_ENTRADAS . " WHERE entry_pdt = {$cod}");

                            if ($entradas->getResult()):
                                $entrada = $entradas->getResult()[0]["qt"];
                                $final = $entrada + ($estoque_atual - $qt);

                                if ($final <= $estoque_minimo):
                                    $cor = "#FFF7D4";
                                else:
                                    $cor = "white";
                                endif;
                            else:

                                if ($final <= $estoque_minimo):
                                    $cor = "#FFF7D4";
                                else:
                                    $cor = "white";
                                endif;
                                $final = ($estoque_atual - $qt);
                            endif;
                            ?>
                            <tr style="background-color: <?= $cor; ?> !important;">
                                <td class="whitespace-nowrap"><?= $nome; ?></td>
                                <td>
                                    <?php
                                    $categorias = new Read;
                                    $categorias->FullRead("SELECT * FROM " . DB_CATEGORIAS . " WHERE id_categoria = {$id_categoria}");
                                    $cat = $categorias->getResult()[0]['nome'];
                                    echo $cat;
                                    ?>
                                </td>
                                <td><?= number_format($preco, 2, ',', '.'); ?></td>
                                <td><?= $final; ?></td>
                                <td class="text-center"><a
                                        href="painel.php?exe=produtos/entrada&produtoid=<?= $cod; ?>&categoriaid=<?= $category_id;?>">Lançar estoque</a> |
                                    <a href="painel.php?exe=produtos/update&produtoid=<?= $cod; ?>&categoriaid=<?= $category_id;?>">Editar</a> | <a
                                        href="painel.php?exe=produtos/index&produtoid=<?= $cod; ?>&action=delete"
                                        onclick="return confirm('Tem certeza de que quer deletar este item?');">Excluir</a>
                                </td>
                            </tr>
                            <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>