<div class="min-h-[calc(100vh-152px)]">
    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty) :
        WSErro("Ops: Você tentou editar uma categoria que não existe no sistema!", WS_INFOR);
    endif;

    $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
    if ($action) :
        require('_models/Categorias.class.php');

        $postAction = filter_input(INPUT_GET, 'categoriaid', FILTER_VALIDATE_INT);
        $postUpdate = new Categorias;

        switch ($action):
            case 'delete':
                $postUpdate->ExeDelete($postAction);
                WSErro($postUpdate->getError()[0], $postUpdate->getError()[1]);
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Categorias cadastradas</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $categorias = new Read;
                        $categorias->ExeRead(DB_CATEGORIAS, " ORDER BY nome ASC");
                        foreach ($categorias->getResult() as $categoria) :
                            extract($categoria);
                        ?>
                            <tr>
                                <td class="whitespace-nowrap"><?= $nome; ?></td>
                                <td class="text-center"><a href="painel.php?exe=categorias/update&categoriaid=<?= $id_categoria; ?>">Editar</a> | <a href="painel.php?exe=categorias/index&categoriaid=<?= $id_categoria; ?>&action=delete">Excluir</a></td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>