<div class="min-h-[calc(100vh-152px)]">
    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty) :
        WSErro("Ops: Você tentou editar um registro que não existe no sistema!", WS_INFOR);
    endif;

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)) :
        WSErro("A sangria foi cadastrada com sucesso no sistema!", WS_ACCEPT);
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Caixa</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Data</th>
                            <th>Usuário</th>
                            <th>Valor</th>
                            <th>Obs</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sangrias = new Read;
                        $sangrias->ExeRead(DB_SANGRIA, " ORDER BY sangria_data DESC");
                        foreach ($sangrias->getResult() as $c) :
                            extract($c);
                        ?>
                            <tr>
                                <td><?= date('d/m/Y H:i', strtotime($sangria_data)); ?></td>
                                <td>
                                    <?php
                                    $usuario = new Read;
                                    $usuario->ExeRead(DB_USERS, " WHERE user_id = {$sangria_user}");
                                    $user = $usuario->getResult()[0]['user_name'];
                                    echo $user;
                                    ?>
                                </td>
                                <td><?= number_format($sangria_valor, 2, ',', '.'); ?></td>
                                <td><?= $sangria_obs; ?></td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>