<div class="min-h-[calc(100vh-152px)]">
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $postid = filter_input(INPUT_GET, 'produtoid', FILTER_VALIDATE_INT);

    if (isset($post) && $post['SendPostForm']) :
        unset($post['SendPostForm']);

        require('_models/Entradas.class.php');
        $cadastra = new Entradas;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()) :
            header('Location: painel.php?exe=produtos/index&createEstoque=true');
        else :
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;

    $produto = new Read;
    $produto->ExeRead(DB_PRODUTOS, " WHERE cod = {$postid}");
    $pdt = $produto->getResult()[0];

    $checkCreate = filter_input(INPUT_GET, 'create', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)) :
        WSErro("O produto foi cadastrado com sucesso no sistema!", WS_ACCEPT);
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Cadastrar entrada de estoque</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Entrada para o produto: <?= $pdt['nome']; ?></h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <input type="hidden" name="entry_user" value="<?= $userlogin['user_id']; ?>" />
                <input type="hidden" name="entry_pdt" value="<?= $postid; ?>" />
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Quantidade comprada</label>
                        <input type="text" class="form-input" name="entry_qt" placeholder="Informe a quantidade comprada" value="<?php if (isset($post['entry_qt'])) echo $post['entry_qt']; ?>">
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" value="Cadastrar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>